/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.jdo;

import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.Transaction;
import javax.transaction.Synchronization;
import org.apache.ojb.otm.OTMConnection;
import org.apache.ojb.otm.OTMKit;

public class TransactionImpl
implements Transaction {
    private PersistenceManager m_pm;
    private OTMKit m_kit;
    private OTMConnection m_conn;

    public TransactionImpl(PersistenceManager pm, OTMKit kit, OTMConnection conn) {
        this.m_pm = pm;
        this.m_conn = conn;
        this.m_kit = kit;
    }

    public void begin() {
        if (this.m_kit.getTransaction(this.m_conn).isInProgress()) {
            throw new JDOUserException("Transaction already in progress");
        }
        this.m_kit.getTransaction(this.m_conn).begin();
    }

    public void commit() {
        if (!this.m_kit.getTransaction(this.m_conn).isInProgress()) {
            throw new JDOUserException("Transaction not in progress");
        }
        this.m_kit.getTransaction(this.m_conn).commit();
    }

    public void rollback() {
        if (!this.m_kit.getTransaction(this.m_conn).isInProgress()) {
            throw new JDOUserException("Transaction not in progress");
        }
        this.m_kit.getTransaction(this.m_conn).rollback();
    }

    public boolean isActive() {
        return this.m_kit.getTransaction(this.m_conn).isInProgress();
    }

    public void setNontransactionalRead(boolean b) {
        throw new JDOUnsupportedOptionException("Unsupported");
    }

    public boolean getNontransactionalRead() {
        return false;
    }

    public void setNontransactionalWrite(boolean b) {
        throw new JDOUnsupportedOptionException("Unsupported");
    }

    public boolean getNontransactionalWrite() {
        return false;
    }

    public void setRetainValues(boolean b) {
    }

    public boolean getRetainValues() {
        return true;
    }

    public void setRestoreValues(boolean b) {
        throw new JDOUnsupportedOptionException("Not Yet Implemented");
    }

    public boolean getRestoreValues() {
        return false;
    }

    public void setOptimistic(boolean b) {
        throw new JDOUnsupportedOptionException("Not yet implemented");
    }

    public boolean getOptimistic() {
        return false;
    }

    public void setSynchronization(Synchronization synchronization) {
        throw new JDOUnsupportedOptionException("Not Yet Implemented");
    }

    public Synchronization getSynchronization() {
        throw new JDOUnsupportedOptionException("Not Yet Implemented");
    }

    public PersistenceManager getPersistenceManager() {
        return this.m_pm;
    }
}

