/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OptimisticLockException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.ObjectEnvelope;
import org.apache.ojb.odmg.OdmgConfiguration;
import org.apache.ojb.odmg.TransactionAbortedExceptionOJB;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.locking.LockManagerFactory;
import org.apache.ojb.odmg.states.StateOldClean;
import org.odmg.LockNotGrantedException;
import org.odmg.TransactionAbortedException;

public class ObjectEnvelopeTable {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$ObjectEnvelopeTable == null ? (class$org$apache$ojb$odmg$ObjectEnvelopeTable = ObjectEnvelopeTable.class$("org.apache.ojb.odmg.ObjectEnvelopeTable")) : class$org$apache$ojb$odmg$ObjectEnvelopeTable);
    private TransactionImpl transaction;
    private Map mhtObjectEnvelopes = new HashMap();
    private ArrayList mvOrderOfIds = new ArrayList();
    private boolean needsCommit = false;
    static /* synthetic */ Class class$org$apache$ojb$odmg$ObjectEnvelopeTable;

    public void refresh() {
        if (this.mhtObjectEnvelopes != null) {
            Iterator iter = this.mvOrderOfIds.iterator();
            while (iter.hasNext()) {
                ObjectEnvelope temp = (ObjectEnvelope)this.mhtObjectEnvelopes.get(iter.next());
                temp.close();
            }
        }
        this.needsCommit = false;
        this.mhtObjectEnvelopes.clear();
        this.mvOrderOfIds.clear();
    }

    public ObjectEnvelopeTable(TransactionImpl myTransaction) {
        this.transaction = myTransaction;
    }

    public void commit() throws TransactionAbortedException, LockNotGrantedException {
        PersistenceBroker broker = this.transaction.getBroker();
        ConnectionManagerIF connMan = broker.serviceConnectionManager();
        boolean saveBatchMode = connMan.isBatchMode();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("PB is in internal tx: " + broker.isInTransaction() + "  broker was: " + broker);
            }
            if (!broker.isInTransaction()) {
                this.log.error("PB associated with current odmg-tx is not in tx");
                throw new TransactionAbortedException("Underlying PB is not in tx");
            }
            connMan.setBatchMode(true);
            this.upgradeImplicitLocksAndCheckIfCommitIsNeeded();
            this.reorder();
            this.commitAllEnvelopes(broker);
            connMan.executeBatch();
            this.setCleanState();
        }
        catch (Throwable t) {
            connMan.clearBatch();
            this.log.error("Commit on object level failed for tx " + this.transaction, t);
            if (t instanceof OptimisticLockException) {
                throw new LockNotGrantedException(t.getMessage());
            }
            throw new TransactionAbortedExceptionOJB(t);
        }
        finally {
            this.needsCommit = false;
            connMan.setBatchMode(saveBatchMode);
        }
    }

    private void commitAllEnvelopes(PersistenceBroker broker) {
        if (this.needsCommit) {
            Iterator iter = ((List)this.mvOrderOfIds.clone()).iterator();
            while (iter.hasNext()) {
                ObjectEnvelope mod = (ObjectEnvelope)this.mhtObjectEnvelopes.get(iter.next());
                mod.getModificationState().commit(mod, broker);
            }
        }
    }

    private void setCleanState() {
        if (this.needsCommit) {
            Iterator iter = ((List)this.mvOrderOfIds.clone()).iterator();
            while (iter.hasNext()) {
                ObjectEnvelope mod = (ObjectEnvelope)this.mhtObjectEnvelopes.get(iter.next());
                if (mod.getModificationState() == StateOldClean.getInstance()) continue;
                mod.refreshObjectImage();
                mod.setModificationState(StateOldClean.getInstance());
            }
        }
    }

    private void upgradeImplicitLocksAndCheckIfCommitIsNeeded() {
        boolean useImplicitLocking = this.getConfiguration().useImplicitLocking();
        Iterator iter = ((List)this.mvOrderOfIds.clone()).iterator();
        while (iter.hasNext()) {
            boolean markDirty = false;
            ObjectEnvelope mod = (ObjectEnvelope)this.mhtObjectEnvelopes.get(iter.next());
            if (!(mod.needsDelete() || mod.needsInsert() || mod.needsUpdate())) {
                if (!mod.hasChanged()) continue;
                if (useImplicitLocking) {
                    this.transaction.lock(mod.getObject(), 2);
                    markDirty = true;
                } else if (LockManagerFactory.getLockManager().checkWrite(this.transaction, mod.getObject())) {
                    markDirty = true;
                }
                if (!markDirty) continue;
                this.needsCommit = true;
                mod.setModificationState(mod.getModificationState().markDirty());
                continue;
            }
            this.needsCommit = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        try {
            PersistenceBroker broker = this.transaction.getBroker();
            Iterator iter = this.mvOrderOfIds.iterator();
            while (iter.hasNext()) {
                ObjectEnvelope mod = (ObjectEnvelope)this.mhtObjectEnvelopes.get(iter.next());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("rollback: " + mod);
                }
                if (mod.hasChanged()) {
                    mod.setModificationState(mod.getModificationState().markDirty());
                }
                mod.getModificationState().rollback(mod, broker);
            }
        }
        finally {
            this.needsCommit = false;
        }
    }

    public void remove(Object pKey) {
        Identity id = null;
        id = pKey instanceof Identity ? (Identity)pKey : new Identity(pKey, this.transaction.getBroker());
        this.mhtObjectEnvelopes.remove(id);
        this.mvOrderOfIds.remove(id);
    }

    public Enumeration elements() {
        return Collections.enumeration(this.mhtObjectEnvelopes.values());
    }

    public ObjectEnvelope getByIdentity(Identity id) {
        return (ObjectEnvelope)this.mhtObjectEnvelopes.get(id);
    }

    public ObjectEnvelope get(Object pKey) {
        Identity id = new Identity(pKey, this.transaction.getBroker());
        ObjectEnvelope result = (ObjectEnvelope)this.mhtObjectEnvelopes.get(id);
        if (result == null) {
            result = new ObjectEnvelope(pKey, this.transaction);
            this.mhtObjectEnvelopes.put(id, result);
            this.mvOrderOfIds.add(id);
            if (this.log.isDebugEnabled()) {
                this.log.debug("register: " + result);
            }
        }
        return result;
    }

    public void put(Object pKey, ObjectEnvelope modification) {
        Identity id = new Identity(pKey, this.transaction.getBroker());
        if (this.log.isDebugEnabled()) {
            this.log.debug("register: " + modification);
        }
        if (!this.mhtObjectEnvelopes.containsKey(id)) {
            this.mvOrderOfIds.add(id);
        }
        this.mhtObjectEnvelopes.put(id, modification);
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        buf.append((Object)"### ObjectEnvelopeTable dump:");
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ObjectEnvelope mod = (ObjectEnvelope)enumeration.nextElement();
            buf.append((Object)mod.toString());
        }
        return buf.toString();
    }

    public boolean contains(Object pKey) {
        Identity id = new Identity(pKey, this.transaction.getBroker());
        return this.mhtObjectEnvelopes.containsKey(id);
    }

    private void reorder() throws IllegalAccessException {
        if (this.needsCommit) {
            int i;
            ArrayList vNewVector = new ArrayList(this.mvOrderOfIds.size());
            HashMap htNewHashtable = new HashMap((int)((double)this.mvOrderOfIds.size() * 1.1), 1.0f);
            HashMap htOldVectorPosition = new HashMap((int)((double)this.mvOrderOfIds.size() * 1.1), 1.0f);
            for (i = 0; i < this.mvOrderOfIds.size(); ++i) {
                htOldVectorPosition.put(this.mvOrderOfIds.get(i), new Integer(i));
            }
            for (i = 0; i < this.mvOrderOfIds.size(); ++i) {
                Identity id = (Identity)this.mvOrderOfIds.get(i);
                if (id == null) continue;
                this.mvOrderOfIds.set(i, null);
                ObjectEnvelope o = (ObjectEnvelope)this.mhtObjectEnvelopes.get(id);
                this.mhtObjectEnvelopes.remove(id);
                this.reorderObject(htNewHashtable, vNewVector, o, id, htOldVectorPosition);
            }
            this.mvOrderOfIds = vNewVector;
            this.mhtObjectEnvelopes = htNewHashtable;
        }
    }

    private void reorderObject(Map htNewHashtable, List newVector, ObjectEnvelope objectToReorder, Identity id, Map htOldVectorPosition) throws IllegalAccessException {
        PersistenceBroker broker = this.transaction.getBroker();
        if (objectToReorder != null) {
            ClassDescriptor cld = broker.getClassDescriptor(objectToReorder.getObject().getClass());
            if (objectToReorder.needsDelete()) {
                this.reorderCollection(htNewHashtable, newVector, objectToReorder, cld, htOldVectorPosition);
                newVector.add(id);
                htNewHashtable.put(id, objectToReorder);
                this.reorderReference(htNewHashtable, newVector, objectToReorder, cld, htOldVectorPosition);
            } else {
                this.reorderReference(htNewHashtable, newVector, objectToReorder, cld, htOldVectorPosition);
                newVector.add(id);
                htNewHashtable.put(id, objectToReorder);
                this.reorderCollection(htNewHashtable, newVector, objectToReorder, cld, htOldVectorPosition);
            }
        }
    }

    private void reorderCollection(Map htNewHashtable, List newVector, ObjectEnvelope objectToReorder, ClassDescriptor cld, Map htOldVectorPosition) throws IllegalAccessException {
        Iterator i = cld.getCollectionDescriptors().iterator();
        while (i.hasNext()) {
            CollectionDescriptor cds = (CollectionDescriptor)i.next();
            Object col = cds.getPersistentField().get(objectToReorder.getObject());
            if (col == null) continue;
            Iterator colIterator = ProxyHelper.isCollectionProxy(col) && !ProxyHelper.getCollectionProxy(col).isLoaded() ? Collections.EMPTY_LIST.iterator() : BrokerHelper.getCollectionIterator(col);
            while (colIterator.hasNext()) {
                Identity id = new Identity(colIterator.next(), this.transaction.getBroker());
                ObjectEnvelope oe = (ObjectEnvelope)this.mhtObjectEnvelopes.get(id);
                if (oe == null) continue;
                this.mvOrderOfIds.set((Integer)htOldVectorPosition.get(id), null);
                this.mhtObjectEnvelopes.remove(id);
                this.reorderObject(htNewHashtable, newVector, oe, id, htOldVectorPosition);
            }
        }
    }

    private void reorderReference(Map htNewHashtable, List newVector, ObjectEnvelope objectToReorder, ClassDescriptor cld, Map htOldVectorPosition) throws IllegalAccessException {
        Iterator i = cld.getObjectReferenceDescriptors().iterator();
        while (i.hasNext()) {
            Identity id;
            ObjectEnvelope oe;
            ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)i.next();
            Object refObj = rds.getPersistentField().get(objectToReorder.getObject());
            if (refObj == null || (oe = (ObjectEnvelope)this.mhtObjectEnvelopes.get(id = new Identity(refObj, this.transaction.getBroker()))) == null) continue;
            this.mhtObjectEnvelopes.remove(id);
            this.mvOrderOfIds.set((Integer)htOldVectorPosition.get(id), null);
            this.reorderObject(htNewHashtable, newVector, oe, id, htOldVectorPosition);
        }
    }

    private OdmgConfiguration getConfiguration() {
        OdmgConfiguration config = (OdmgConfiguration)((Object)PersistenceBrokerFactory.getConfigurator().getConfigurationFor(null));
        return config;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

