/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.core.proxy.CollectionProxy;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.CollectionProxyListener;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.MaterializationListener;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.GUID;
import org.apache.ojb.broker.util.configuration.Configurable;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.DatabaseImpl;
import org.apache.ojb.odmg.OJBTxManager;
import org.apache.ojb.odmg.ObjectEnvelope;
import org.apache.ojb.odmg.ObjectEnvelopeTable;
import org.apache.ojb.odmg.OdmgConfiguration;
import org.apache.ojb.odmg.TransactionAbortedExceptionOJB;
import org.apache.ojb.odmg.TransactionExt;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.TxUtil;
import org.apache.ojb.odmg.locking.LockManager;
import org.apache.ojb.odmg.locking.LockManagerFactory;
import org.odmg.DatabaseClosedException;
import org.odmg.LockNotGrantedException;
import org.odmg.ODMGRuntimeException;
import org.odmg.Transaction;
import org.odmg.TransactionAbortedException;
import org.odmg.TransactionInProgressException;
import org.odmg.TransactionNotInProgressException;

public class TransactionImpl
implements Transaction,
MaterializationListener,
Configurable,
CollectionProxyListener,
TransactionExt {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$TransactionImpl == null ? (class$org$apache$ojb$odmg$TransactionImpl = TransactionImpl.class$("org.apache.ojb.odmg.TransactionImpl")) : class$org$apache$ojb$odmg$TransactionImpl);
    private Hashtable myNrm = null;
    private boolean useWriteLocks;
    private boolean useImplicitLocking;
    private String txGUID;
    protected PersistenceBroker broker = null;
    private ArrayList registeredForLock = new ArrayList();
    private OJBTxManager txManager;
    private int m_txStatus = 6;
    private ObjectEnvelopeTable objectEnvelopeTable = null;
    private DatabaseImpl curDB;
    private ArrayList registeredIndirectionHandlers = new ArrayList();
    private ArrayList registeredCollectionProxies = new ArrayList();
    private ArrayList unmaterializedLocks = new ArrayList();
    private ArrayList locksToRelease = new ArrayList();
    static /* synthetic */ Class class$org$apache$ojb$odmg$TransactionImpl;

    public TransactionImpl(DatabaseImpl theCurrentDB) {
        this.txManager = TxManagerFactory.instance();
        this.txGUID = new GUID().toString();
        this.curDB = theCurrentDB;
    }

    public DatabaseImpl getAssociatedDatabase() {
        return this.curDB;
    }

    protected int getStatus() {
        return this.m_txStatus;
    }

    protected void setStatus(int status) {
        this.m_txStatus = status;
    }

    private void checkForDB() {
        if (this.curDB == null || !this.curDB.isOpen()) {
            this.log.error("Transaction without a associated open Database.");
            throw new TransactionAbortedExceptionOJB("No open database found. Open the database before handling transactions");
        }
    }

    public boolean isOpen() {
        return this.getStatus() == 0 || this.getStatus() == 1 || this.getStatus() == 2 || this.getStatus() == 7 || this.getStatus() == 8;
    }

    private void checkOpen() {
        if (!this.isOpen()) {
            throw new TransactionNotInProgressException("Transaction was not open, call tx.begin() before perform action, current status is: " + TxUtil.getStatusString(this.getStatus()));
        }
    }

    public void join() {
        this.checkOpen();
        this.txManager.deregisterTx(this);
        this.txManager.registerTx(this);
    }

    public void lock(Object obj, int lockMode) throws LockNotGrantedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("lock object was called on tx " + this + ", object is " + obj.toString());
        }
        this.checkOpen();
        if (!ProxyHelper.isProxy(obj)) {
            ClassDescriptor cld;
            if (this.log.isDebugEnabled()) {
                this.log.debug("object is a proxy");
            }
            if (!(cld = this.getBroker().getClassDescriptor(obj.getClass())).isAcceptLocks()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("skipping lock on class: " + cld.getClassNameOfObject() + " object " + obj.toString());
                }
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("proceeding with lock on class: " + cld.getClassNameOfObject() + " object " + obj.toString());
            }
            this.assignReferenceFKs(obj, this.getBroker().getClassDescriptor(obj.getClass()).getObjectReferenceDescriptors());
        }
        LockManager lm = LockManagerFactory.getLockManager();
        if (lockMode == 1) {
            if (!lm.readLock(this, obj)) {
                throw new LockNotGrantedException("Can not lock for READ: " + obj);
            }
        } else if (lockMode == 4) {
            if (!lm.writeLock(this, obj)) {
                throw new LockNotGrantedException("Can not lock for WRITE: " + obj);
            }
        } else if (lockMode == 2 && !lm.upgradeLock(this, obj)) {
            throw new LockNotGrantedException("Can not lock for UPGRADE: " + obj);
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("registering lock on object at " + System.currentTimeMillis());
            }
            this.register(obj, lockMode);
        }
        catch (Throwable t) {
            this.log.error("Locking obj " + obj + " with lock mode " + lockMode + " failed", t);
            lm.releaseLock(this, obj);
            throw new LockNotGrantedException(t.getMessage());
        }
    }

    public void leave() {
        this.checkOpen();
        this.txManager.deregisterTx(this);
    }

    private synchronized void doCommitOnObjects(boolean keepLogs) throws TransactionAbortedException, LockNotGrantedException {
        ObjectEnvelope item;
        if (this.log.isDebugEnabled()) {
            this.log.debug("call beginTransaction() on PB instance");
        }
        if (!this.getBroker().isInTransaction()) {
            this.broker.beginTransaction();
        }
        Enumeration enumeration = this.objectEnvelopeTable.elements();
        while (enumeration.hasMoreElements()) {
            item = (ObjectEnvelope)enumeration.nextElement();
            item.beforeCommit();
        }
        this.objectEnvelopeTable.commit();
        enumeration = this.objectEnvelopeTable.elements();
        while (enumeration.hasMoreElements()) {
            item = (ObjectEnvelope)enumeration.nextElement();
            if (keepLogs) {
                this.locksToRelease.add(item.getObject());
            }
            item.afterCommit();
        }
        this.registeredForLock.clear();
    }

    protected synchronized void doAbort() {
        ObjectEnvelope item;
        Enumeration objectsToAbort = this.objectEnvelopeTable.elements();
        while (objectsToAbort.hasMoreElements()) {
            item = (ObjectEnvelope)objectsToAbort.nextElement();
            item.beforeAbort();
        }
        this.objectEnvelopeTable.rollback();
        objectsToAbort = this.objectEnvelopeTable.elements();
        while (objectsToAbort.hasMoreElements()) {
            item = (ObjectEnvelope)objectsToAbort.nextElement();
            item.afterAbort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doClose() {
        if (!this.isOpen()) {
            throw new IllegalStateException("persist.missingEnd. Tx Status: " + TxUtil.getStatusString(this.getStatus()));
        }
        try {
            Enumeration enumeration = this.objectEnvelopeTable.elements();
            while (enumeration.hasMoreElements()) {
                Object obj = ((ObjectEnvelope)enumeration.nextElement()).getObject();
                this.removeLock(obj, 4);
            }
            Iterator it = this.unmaterializedLocks.iterator();
            while (it.hasNext()) {
                this.removeLock(it.next(), 4);
            }
            it = this.locksToRelease.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                this.removeLock(obj, 4);
            }
            this.unRegisterFromAllIndirectionHandlers();
            this.unRegisterFromAllCollectionProxies();
            Object var5_4 = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Close Transaction and release current PB " + this.broker + " on tx " + this);
            }
            this.txManager.deregisterTx(this);
            this.refresh();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Close Transaction and release current PB " + this.broker + " on tx " + this);
            }
            this.txManager.deregisterTx(this);
            this.refresh();
            throw throwable;
        }
    }

    protected void refresh() {
        block5: {
            try {
                this.objectEnvelopeTable.refresh();
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block5;
                this.log.debug("error closing object envelope table : " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (this.broker != null && !this.broker.isClosed()) {
            try {
                this.broker.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.myNrm.clear();
        this.broker = null;
        this.registeredForLock.clear();
        this.unmaterializedLocks.clear();
        this.locksToRelease.clear();
        this.m_txStatus = 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Checkpoint was called, commit changes hold locks on tx " + this);
        }
        try {
            this.checkOpen();
            this.doCommitOnObjects(true);
            if (this.broker != null && this.broker.isInTransaction()) {
                this.broker.commitTransaction();
            }
        }
        catch (Throwable t) {
            this.log.error("checkpoint call failed, do abort transaction", t);
            try {
                this.doAbort();
            }
            finally {
                this.doClose();
                this.m_txStatus = 4;
            }
            if (t instanceof TransactionAbortedException) {
                throw (TransactionAbortedException)t;
            }
            if (t instanceof LockNotGrantedException) {
                throw (LockNotGrantedException)t;
            }
            throw new TransactionAbortedExceptionOJB(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Flush was called - write to database, do not commit, hold locks on tx " + this);
        }
        try {
            this.checkOpen();
            this.doCommitOnObjects(true);
        }
        catch (Throwable t) {
            this.log.error("flush failed", t);
            try {
                this.doAbort();
            }
            finally {
                this.doClose();
                this.m_txStatus = 4;
            }
            if (t instanceof TransactionAbortedException) {
                throw (TransactionAbortedException)t;
            }
            if (t instanceof LockNotGrantedException) {
                throw (LockNotGrantedException)t;
            }
            throw new TransactionAbortedExceptionOJB(t);
        }
    }

    public void markDelete(Object anObject) {
        ObjectEnvelope otw = this.objectEnvelopeTable.get(anObject);
        otw.setModificationState(otw.getModificationState().markDelete());
    }

    public void markDirty(Object anObject) {
        ObjectEnvelope otw = this.objectEnvelopeTable.get(anObject);
        otw.setModificationState(otw.getModificationState().markDirty());
    }

    public boolean tryLock(Object obj, int lockMode) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Try to lock object was called on tx " + this);
        }
        this.checkOpen();
        try {
            this.lock(obj, lockMode);
            return true;
        }
        catch (LockNotGrantedException ex) {
            return false;
        }
    }

    private boolean removeLock(Object obj, int lockType) {
        return LockManagerFactory.getLockManager().releaseLock(this, obj);
    }

    public void commit() {
        this.checkOpen();
        try {
            this.prepare();
            if (this.m_txStatus == 1) {
                throw new TransactionAbortedExceptionOJB("persist.markedRollback");
            }
            if (this.m_txStatus != 2) {
                throw new IllegalStateException("persist.missingPrepare");
            }
            this.m_txStatus = 8;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Commit transaction " + this + ", commit on broker " + this.broker);
            }
            this.getBroker().commitTransaction();
            this.doClose();
            this.m_txStatus = 3;
        }
        catch (ODMGRuntimeException ex) {
            this.m_txStatus = 1;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Commit fails, do abort this tx", ex);
            }
            this.abort();
            throw ex;
        }
    }

    protected boolean prepare() throws TransactionAbortedException, LockNotGrantedException {
        if (this.m_txStatus == 1) {
            throw new TransactionAbortedExceptionOJB("persist.markedRollback");
        }
        if (this.m_txStatus != 0) {
            throw new IllegalStateException("persist.noTransaction");
        }
        try {
            this.m_txStatus = 7;
            this.doCommitOnObjects(false);
            this.m_txStatus = 2;
        }
        catch (LockNotGrantedException e) {
            this.log.error("Could not prepare for commit: " + e.getMessage());
            this.m_txStatus = 1;
            throw e;
        }
        catch (TransactionAbortedException e) {
            this.log.error("Could not prepare for commit: " + e.getMessage());
            this.m_txStatus = 1;
            throw e;
        }
        catch (PersistenceBrokerSQLException pbse) {
            this.log.error("Could not prepare for commit: " + pbse.getMessage());
            this.m_txStatus = 1;
            throw pbse;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        if (this.m_txStatus == 4) {
            return;
        }
        if (this.m_txStatus != 0 && this.m_txStatus != 2 && this.m_txStatus != 1) {
            throw new IllegalStateException("Illegal state for abort call, state was '" + TxUtil.getStatusString(this.m_txStatus) + "'");
        }
        this.log.info("Abort transaction was called on tx " + this + ", associated PB was " + this.broker);
        try {
            this.doAbort();
            PersistenceBroker _broker = this.getBroker();
            if (_broker.isInTransaction()) {
                _broker.abortTransaction();
            }
        }
        finally {
            this.doClose();
            this.m_txStatus = 4;
        }
    }

    public synchronized void begin() {
        if (this.curDB == null || !this.curDB.isOpen()) {
            throw new DatabaseClosedException("Database is not open. Must have an open DB to begin the Tx.");
        }
        if (this.isOpen()) {
            this.log.error("Transaction is already open");
            throw new TransactionInProgressException("Impossible to call begin on already opened tx");
        }
        this.objectEnvelopeTable = new ObjectEnvelopeTable(this);
        this.myNrm = new Hashtable();
        this.txManager.registerTx(this);
        this.m_txStatus = 0;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Begin transaction was called on tx " + this + ", with associated PB " + this.broker);
        }
    }

    public String getGUID() {
        return this.txGUID;
    }

    public Object getObjectByIdentity(Identity id) throws PersistenceBrokerException {
        this.checkOpen();
        ObjectEnvelope envelope = this.objectEnvelopeTable.getByIdentity(id);
        if (envelope != null) {
            return envelope.needsDelete() ? null : envelope.getObject();
        }
        return this.getBroker().getObjectByIdentity(id);
    }

    public boolean isDeleted(Identity id) {
        ObjectEnvelope envelope = this.objectEnvelopeTable.getByIdentity(id);
        return envelope == null ? false : envelope.needsDelete();
    }

    private synchronized void register(Object newTxObject, int lockMode) throws LockNotGrantedException, PersistenceBrokerException {
        Object objectToRegister = newTxObject;
        IndirectionHandler handler = null;
        handler = ProxyHelper.getIndirectionHandler(newTxObject);
        if (handler != null) {
            if (handler.alreadyMaterialized()) {
                objectToRegister = handler.getRealSubject();
            } else {
                this.registerToIndirectionHandler(handler);
                this.registerUnmaterializedLocks(newTxObject);
                objectToRegister = null;
            }
        }
        if (objectToRegister != null) {
            ClassDescriptor cld = this.getBroker().getClassDescriptor(objectToRegister.getClass());
            ObjectEnvelope envelope = this.objectEnvelopeTable.getByIdentity(new Identity(objectToRegister, this.getBroker(), cld));
            if (envelope == null || envelope.needsDelete()) {
                this.doLockReferences(cld, objectToRegister, lockMode);
                this.objectEnvelopeTable.put(objectToRegister, new ObjectEnvelope(objectToRegister, this));
                this.doLockCollections(cld, objectToRegister, lockMode);
            }
        }
    }

    protected void doLockReferences(ClassDescriptor cld, Object objectToRegister, int assLockMode) throws LockNotGrantedException {
        if (!this.useWriteLocks) {
            assLockMode = 1;
        }
        if (this.useImplicitLocking) {
            this.lockReferences(cld, objectToRegister, assLockMode);
        }
    }

    protected void doLockCollections(ClassDescriptor cld, Object objectToRegister, int assLockMode) throws LockNotGrantedException {
        if (!this.useWriteLocks) {
            assLockMode = 1;
        }
        if (this.useImplicitLocking) {
            this.lockCollections(cld, objectToRegister, assLockMode);
        }
    }

    private void assertFkAssignment(Object obj, Object ref, ObjectReferenceDescriptor rds) {
        try {
            if (!ProxyHelper.isProxy(obj) && ref != null) {
                Object[] refPkValues;
                Object refInstance = ProxyHelper.getRealObject(ref);
                ClassDescriptor objCld = this.getBroker().getClassDescriptor(obj.getClass());
                FieldDescriptor[] objFkFields = rds.getForeignKeyFieldDescriptors(objCld);
                if (refInstance != null) {
                    ClassDescriptor refCld = this.getBroker().getClassDescriptor(refInstance.getClass());
                    refPkValues = this.getBroker().serviceBrokerHelper().getKeyValues(refCld, refInstance, false);
                } else {
                    refPkValues = new ValueContainer[objFkFields.length];
                    Arrays.fill(refPkValues, null);
                }
                if (objFkFields != null) {
                    FieldDescriptor fld = null;
                    for (int i = 0; i < objFkFields.length; ++i) {
                        fld = objFkFields[i];
                        fld.getPersistentField().set(obj, refPkValues[i] != null ? ((ValueContainer)refPkValues[i]).getValue() : null);
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new PersistenceBrokerException(t);
        }
    }

    private void assignReferenceFKs(Object obj, Vector vecRds) throws PersistenceBrokerException {
        try {
            Iterator i = vecRds.iterator();
            while (i.hasNext()) {
                ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)i.next();
                Object ref = rds.getPersistentField().get(obj);
                this.assertFkAssignment(obj, ref, rds);
            }
        }
        catch (Throwable t) {
            throw new PersistenceBrokerException(t);
        }
    }

    private void lockCollections(ClassDescriptor cld, Object newTxObject, int lockMode) throws PersistenceBrokerException {
        Iterator i = cld.getCollectionDescriptors().iterator();
        while (i.hasNext()) {
            CollectionDescriptor cds = (CollectionDescriptor)i.next();
            Object col = cds.getPersistentField().get(newTxObject);
            if (col == null) continue;
            CollectionProxy proxy = ProxyHelper.getCollectionProxy(col);
            if (proxy != null && !proxy.isLoaded()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("adding self as listener to collection proxy");
                }
                proxy.addListener(this);
                continue;
            }
            Iterator colIterator = BrokerHelper.getCollectionIterator(col);
            ClassDescriptor itemCld = this.getBroker().getClassDescriptor(cds.getItemClass());
            ValueContainer[] objPkValues = this.getBroker().serviceBrokerHelper().getKeyValues(cld, newTxObject, false);
            FieldDescriptor[] itemFkFields = cds.getForeignKeyFieldDescriptors(itemCld);
            Object item = null;
            try {
                while (colIterator.hasNext()) {
                    item = colIterator.next();
                    IndirectionHandler handler = ProxyHelper.getIndirectionHandler(item);
                    if (handler != null) {
                        if (!handler.alreadyMaterialized()) continue;
                        item = handler.getRealSubject();
                    }
                    if (!cds.isMtoNRelation()) {
                        if (itemCld.isInterface()) {
                            ClassDescriptor concreteItemCld = this.getBroker().getClassDescriptor(item.getClass());
                            itemFkFields = cds.getForeignKeyFieldDescriptors(concreteItemCld);
                        }
                        for (int j = 0; j < itemFkFields.length; ++j) {
                            FieldDescriptor fld = itemFkFields[j];
                            fld.getPersistentField().set(item, objPkValues[j].getValue());
                        }
                    }
                    this.lock(item, lockMode);
                }
            }
            catch (PersistenceBrokerException e) {
                String eol = SystemUtils.LINE_SEPARATOR;
                this.log.error("Error while set FK in collection references[" + eol + "current reference descriptor:" + eol + cds.toXML() + eol + "current item object: " + item + eol + "main object class: " + newTxObject.getClass().getName() + eol + "]", (Throwable)((Object)e));
                throw e;
            }
            catch (LockNotGrantedException e) {
                String eol = SystemUtils.LINE_SEPARATOR;
                this.log.error("Lock not granted, while set FK in collection references[" + eol + "current reference descriptor:" + eol + cds.toXML() + eol + "object to lock: " + item + eol + "main object class: " + newTxObject.getClass().getName() + eol + "]", e);
                throw e;
            }
        }
    }

    private void lockReferences(ClassDescriptor cld, Object newTxObject, int lockMode) throws PersistenceBrokerException {
        if (newTxObject != null && !ProxyHelper.isProxy(newTxObject)) {
            this.registeredForLock.add(newTxObject);
        }
        Iterator i = cld.getObjectReferenceDescriptors().iterator();
        while (i.hasNext()) {
            ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)i.next();
            Object refObj = rds.getPersistentField().get(newTxObject);
            if (refObj == null) continue;
            if (ProxyHelper.isProxy(refObj)) {
                this.lock(refObj, lockMode);
                continue;
            }
            if (this.registeredForLock.contains(refObj)) continue;
            this.lock(refObj, lockMode);
        }
    }

    Identity getNrmEntry(String name) {
        return (Identity)this.myNrm.get(name);
    }

    void putNrmEntry(String key, Identity value) {
        this.myNrm.put(key, value);
    }

    boolean unbindNrmEntry(String key) {
        Identity oid = (Identity)this.myNrm.get(key);
        if (oid != null) {
            this.objectEnvelopeTable.remove(oid);
        }
        return this.myNrm.remove(key) != null;
    }

    public void beforeMaterialization(IndirectionHandler handler, Identity oid) {
    }

    public void afterMaterialization(IndirectionHandler handler, Object materializedObject) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("deferred registration: " + new Identity(materializedObject, this.getBroker()).toString());
        }
        try {
            this.register(materializedObject, 1);
        }
        catch (Throwable t) {
            this.log.error("Register materialized object with this tx failed", t);
            throw new LockNotGrantedException(t.getMessage());
        }
        this.unregisterFromIndirectionHandler(handler);
    }

    protected synchronized void unRegisterFromAllIndirectionHandlers() {
        for (int i = this.registeredIndirectionHandlers.size() - 1; i >= 0; --i) {
            this.unregisterFromIndirectionHandler((IndirectionHandler)this.registeredIndirectionHandlers.get(i));
        }
    }

    protected synchronized void unRegisterFromAllCollectionProxies() {
        for (int i = this.registeredCollectionProxies.size() - 1; i >= 0; --i) {
            this.unregisterFromCollectionProxy((CollectionProxy)this.registeredCollectionProxies.get(i));
        }
    }

    protected synchronized void unregisterFromCollectionProxy(CollectionProxy handler) {
        handler.removeListener(this);
        this.registeredCollectionProxies.remove(handler);
    }

    protected synchronized void unregisterFromIndirectionHandler(IndirectionHandler handler) {
        handler.removeListener(this);
        this.registeredIndirectionHandlers.remove(handler);
    }

    protected synchronized void registerToIndirectionHandler(IndirectionHandler handler) {
        handler.addListener(this);
        this.registeredIndirectionHandlers.add(handler);
    }

    protected void registerUnmaterializedLocks(Object obj) {
        this.unmaterializedLocks.add(obj);
    }

    public PersistenceBroker getBroker() {
        if (this.broker == null) {
            this.checkOpen();
            try {
                this.checkForDB();
                this.broker = PersistenceBrokerFactory.createPersistenceBroker(this.curDB.getPBKey());
            }
            catch (PBFactoryException e) {
                this.log.error("Cannot obtain PersistenceBroker from PersistenceBrokerFactory, found PBKey was " + this.curDB.getPBKey(), (Throwable)((Object)e));
                throw new PersistenceBrokerException((Throwable)((Object)e));
            }
        }
        return this.broker;
    }

    public void configure(Configuration config) throws ConfigurationException {
        OdmgConfiguration odmgConfig = (OdmgConfiguration)((Object)config);
        this.useWriteLocks = odmgConfig.lockAssociationAsWrites();
        this.useImplicitLocking = odmgConfig.useImplicitLocking();
    }

    public synchronized void setImplicitLocking(boolean value) {
        this.useImplicitLocking = value;
    }

    public void beforeLoading(CollectionProxyDefaultImpl colProxy) {
    }

    public void afterLoading(CollectionProxyDefaultImpl colProxy) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("loading a proxied collection a collection: " + colProxy);
        }
        if (this.registeredCollectionProxies.contains(colProxy)) {
            this.registeredCollectionProxies.remove(colProxy);
            colProxy.removeListener(this);
        }
        Collection data = colProxy.getData();
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!this.useImplicitLocking || !this.isOpen()) continue;
            int lock = this.useWriteLocks ? 4 : 1;
            this.register(o, lock);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

