/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.io.Serializable;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldFactory;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DListImpl;

public class DListEntry
implements Serializable {
    private static final long serialVersionUID = -3280555665769116060L;
    protected int id = 0;
    protected int dlistId = 0;
    protected DListImpl m_dList;
    protected int position;
    protected Identity oid;
    protected Object realSubject;
    protected PBKey pbKey;

    public DListEntry() {
        if (!PersistentFieldFactory.usesAccessorsAndMutators()) {
            this.id = this.generateNewId();
        }
    }

    public DListEntry(PBKey pbKey) {
        this.pbKey = pbKey;
        if (!PersistentFieldFactory.usesAccessorsAndMutators()) {
            this.id = this.generateNewId();
        }
    }

    public DListEntry(int anId, int aDlistId, int pos, Identity anOid) {
        this.id = anId;
        this.dlistId = aDlistId;
        this.position = pos;
        this.oid = anOid;
    }

    public DListEntry(DListImpl theDlist, Object theObject) {
        this.pbKey = theDlist.getPBKey();
        this.m_dList = theDlist;
        this.dlistId = theDlist.getId();
        this.position = theDlist.size();
        TransactionImpl tx = TxManagerFactory.instance().getTransaction();
        if (tx != null) {
            this.oid = new Identity(theObject, tx.getBroker());
        } else {
            PersistenceBroker broker = PersistenceBrokerFactory.defaultPersistenceBroker();
            this.oid = new Identity(theObject, broker);
            broker.close();
        }
        this.realSubject = theObject;
        if (!PersistentFieldFactory.usesAccessorsAndMutators()) {
            this.id = this.generateNewId();
        }
    }

    public Identity getOid() {
        return this.oid;
    }

    public void setOid(Identity oid) {
        this.oid = oid;
    }

    public PBKey getPBKey() {
        return this.pbKey;
    }

    public void setPBKey(PBKey pbKey) {
        this.pbKey = pbKey;
    }

    protected int generateNewId() {
        PBCapsule capsule = new PBCapsule(this.pbKey, TxManagerFactory.instance().getTransaction());
        try {
            int result;
            PersistenceBroker broker = capsule.getBroker();
            FieldDescriptor fld = broker.getClassDescriptor(this.getClass()).getAutoIncrementFields()[0];
            Integer val = (Integer)broker.serviceSequenceManager().getUniqueValue(fld);
            int n = result = val.intValue();
            return n;
        }
        catch (Exception e) {
            LoggerFactory.getDefaultLogger().error("DListEntry: Generation of new id failed", e);
            throw new PersistenceBrokerException(e);
        }
        finally {
            capsule.destroy();
        }
    }

    public int getPosition() {
        return this.position;
    }

    public Object getRealSubject() {
        try {
            if (this.realSubject == null) {
                this.materializeRealSubject();
            }
        }
        catch (Exception e) {
            LoggerFactory.getDefaultLogger().error("Cannot materialize real subject", e);
        }
        return this.realSubject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void materializeRealSubject() throws PersistenceBrokerException {
        PBCapsule capsule = new PBCapsule(this.pbKey, TxManagerFactory.instance().getTransaction());
        try {
            this.realSubject = capsule.getBroker().getObjectByIdentity(this.oid);
        }
        finally {
            if (capsule != null) {
                capsule.destroy();
            }
        }
    }

    public void setPosition(int newPosition) {
        this.position = newPosition;
    }

    void setRealSubject(Object realSubject) {
        this.realSubject = realSubject;
    }

    public String toString() {
        if (this.realSubject == null) {
            return this.oid.toString();
        }
        return this.realSubject.toString();
    }

    public int getDlistId() {
        if (this.dlistId == -1) {
            this.dlistId = this.m_dList != null ? this.m_dList.getId() : this.generateNewId();
        }
        return this.dlistId;
    }

    public void setDlistId(int dlistId) {
        this.dlistId = dlistId;
    }

    public int getId() {
        if (this.id == -1) {
            this.id = this.generateNewId();
        }
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

