/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.locking.AbstractLockStrategy;
import org.apache.ojb.odmg.locking.LockEntry;

public class ReadUncommittedStrategy
extends AbstractLockStrategy {
    public boolean readLock(TransactionImpl tx, Object obj) {
        return true;
    }

    public boolean writeLock(TransactionImpl tx, Object obj) {
        LockEntry writer = this.getWriter(obj);
        if (writer == null) {
            if (this.setWriter(tx, obj)) {
                return true;
            }
            return this.writeLock(tx, obj);
        }
        return writer.isOwnedBy(tx);
    }

    public boolean upgradeLock(TransactionImpl tx, Object obj) {
        LockEntry writer = this.getWriter(obj);
        if (writer == null) {
            if (this.setWriter(tx, obj)) {
                return true;
            }
            return this.upgradeLock(tx, obj);
        }
        return writer.isOwnedBy(tx);
    }

    public boolean releaseLock(TransactionImpl tx, Object obj) {
        LockEntry writer = this.getWriter(obj);
        if (writer != null && writer.isOwnedBy(tx)) {
            this.removeWriter(writer);
            return true;
        }
        return true;
    }

    public boolean checkRead(TransactionImpl tx, Object obj) {
        return true;
    }

    public boolean checkWrite(TransactionImpl tx, Object obj) {
        LockEntry writer = this.getWriter(obj);
        return writer != null && writer.isOwnedBy(tx);
    }
}

